/*
	Programa servidor de ECO
	Configuracin del puerto serie: 9600, 8, N, 1
	Cuando se recibe un caracter se cambia el estado del LED RB0
*/


#include <p18f452.h>
#include <usart.h>


void main(void) {
	unsigned char car;
	
	// configuramos puerto B como salida
	TRISB=0;   
	PORTB=0;

	// Configuramos el puerto serie
	SPBRG = 25 ; 
	TRISC = TRISC & 0xBF;  // RC6 salida
	TRISC = TRISC | 0x80;  // RC7 entrada
	TXSTA = 0x24;          // Tx control register
	RCSTA = 0x90;          // Rx control register


	// programa principal
	while (1) {
		while ( !PIR1bits.RCIF );  // Espera a que haya un dato listo
		car = RCREG;      // Lee el caracter nuevo
		PORTB ^= 0x01;    // Cambia el estado del LED
		TXREG = car;      // Manda el caracter recibido
	}
}


	
